<?php

namespace App\Http\Controllers;

use App\Models\Course;
use App\Models\Expense;
use App\Models\Setting;
use App\Models\Teacher;
use App\Models\Enrollment;
use App\Models\ReneHistory;
use App\Models\Worker;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PHPUnit\Framework\Constraint\Count;

class ReportController extends Controller
{


    public function income_report(Request $request) {


        $sdate = !empty($request['date_from']) ? $request['date_from'] : date('Y-m-d');
        $edate = !empty($request['to_date']) ? $request['to_date'] : date('Y-m-d');

        $about = Setting::first();

        // Get total expenses within the date range
        $total_expense = Expense::whereDate('created_at', '>=', $sdate)
                                ->whereDate('created_at', '<=', $edate)
                                ->sum('amount'); // Sum the 'amount' column

        // Get total income (discounted prices) and student count within the date range
        $enrolments = ReneHistory::whereDate('created_at', '>=', $sdate)
                                ->whereDate('created_at', '<=', $edate);

        $total_income = $enrolments->sum('employee_earning'); // Sum the 'discounted_price' column
        $total_deployments = $enrolments->distinct('deploy_id')->count('deploye_id'); // Count unique students

        // Calculate profit as income minus expense
        $profit = $total_income - $total_expense;

        // Define report name
        $report_name = 'Income Report';


        if (!Auth::check()) {

            return redirect()->route('login_page')->with('error', trans('messages.please_log_in', [], session('locale')));
        }

        $user = Auth::user();

        if (in_array(6, explode(',', $user->permit_type))) {

            return view('reports.income_report', compact('sdate', 'edate', 'about', 'report_name', 'total_expense', 'total_income', 'total_deployments', 'profit'));
        } else {

             return redirect()->route('/')->with('error', trans('messages.you_dont_have_permissions', [], session('locale')));

        }
        // Pass data to the view
    }


    public function employee_income_report(Request $request) {

        // Set start and end dates based on the request, or use today's date as default
        $sdate = !empty($request['date_from']) ? $request['date_from'] : date('Y-m-d');
        $edate = !empty($request['to_date']) ? $request['to_date'] : date('Y-m-d');




        $about = Setting::first();

        // Query for enrollments for the specified course
        $enrolments = ReneHistory::
        whereDate('created_at', '>=', $sdate)
        ->whereDate('created_at', '<=', $edate)
        ->get();

        $workers = Worker::all();

        $report_name = 'Employee Income Report';

        if (!Auth::check()) {

            return redirect()->route('login_page')->with('error', trans('messages.please_log_in', [], session('locale')));
        }

        $user = Auth::user();

        if (in_array(6, explode(',', $user->permit_type))) {

            return view('reports.employee_icome_report', compact('sdate', 'workers', 'enrolments',  'edate', 'about', 'report_name'));
        } else {

             return redirect()->route('/')->with('error', trans('messages.you_dont_have_permissions', [], session('locale')));

        }

        // Pass data to the view
    }


    public function expense_report(Request $request) {

        // Set start and end dates based on the request, or use today's date as default
        $sdate = !empty($request['date_from']) ? $request['date_from'] : date('Y-m-d');
        $edate = !empty($request['to_date']) ? $request['to_date'] : date('Y-m-d');

        // Retrieve the first setting (general information)
        $about = Setting::first();


        $expenses = Expense::query();

        if (!empty($sdate) && !empty($edate)) {
            $expenses->whereDate('created_at', '>=', $sdate)
                     ->whereDate('created_at', '<=', $edate);
        }

        // Fetch the expenses (with or without the date filter)
        $expenses = $expenses->get();




        // Define the report name
        $report_name = 'Expense Report';


        if (!Auth::check()) {

            return redirect()->route('login_page')->with('error', trans('messages.please_log_in', [], session('locale')));
        }

        $user = Auth::user();

        if (in_array(6, explode(',', $user->permit_type))) {

            return view('reports.expense_report', compact('sdate', 'expenses', 'edate', 'about', 'report_name', ));
        } else {

             return redirect()->route('/')->with('error', trans('messages.you_dont_have_permissions', [], session('locale')));

        }

        // Pass data to the view
    }










}
