<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Skill;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SkillController extends Controller
{
    public function index(){


        if (!Auth::check()) {

            return redirect()->route('login_page')->with('error', trans('messages.please_log_in', [], session('locale')));
        }

        $user = Auth::user();

        if (in_array(11, explode(',', $user->permit_type))) {

            return view ('worker_status.skill');

        } else {


 return redirect()->route('/')->with('error', trans('messages.you_dont_have_permissions', [], session('locale')));
        }

    }

    public function show_skill()
    {
        $sno=0;

        $view_skill= Skill::all();
        if(count($view_skill)>0)
        {
            foreach($view_skill as $value)
            {





                $modal='<a class="btn btn-outline-secondary btn-sm edit" data-bs-toggle="modal" data-bs-target="#add_skill_modal" onclick=edit("'.$value->id.'") title="Edit">
                            <i class="fas fa-pencil-alt" title="Edit"></i>
                        </a>
                        <a class="btn btn-outline-secondary btn-sm edit" onclick=del("'.$value->id.'") title="Delete">
                            <i class="fas fa-trash" title="Edit"></i>
                        </a>';
                $add_data=get_date_only($value->created_at);



                $sno++;
                $json[] = array(
                $sno,
                $value->skill_name,
                '<span style="text-align: justify; white-space: pre-line;">' . $value->notes . '</span>',
                $value->added_by,
                $modal
                );



            }
            $response = array();
            $response['success'] = true;
            $response['aaData'] = $json;
            echo json_encode($response);
        }
        else
        {
            $response = array();
            $response['sEcho'] = 0;
            $response['iTotalRecords'] = 0;
            $response['iTotalDisplayRecords'] = 0;
            $response['aaData'] = [];
            echo json_encode($response);
        }
    }

    public function add_skill(Request $request)
    {

        $user_id = Auth::id();
        $userData = User::find($user_id);
        $user_name = $userData->user_name;

        $skill = new Skill();
        $skill->skill_name = $request['skill_name'];
        $skill->notes = $request['notes'];
        $skill->added_by = $user_name;
        $skill->user_id = $user_id;
        $skill->save();

        return response()->json(['skill_id' => $skill->id, 'skill' => 1]);
    }


    public function edit_skill(Request $request)
    {
        $skill_id = $request->input('id');
        $skill_data = Skill::where('id', $skill_id)->first();

        if (!$skill_data) {
            return response()->json(['error' => trans('messages.skill_not_found', [], session('locale'))], 404);
        }

        $course_ids = !empty($skill_data->course_id) ? explode(',', $skill_data->course_id) : [];

        $select_option='';



        $data = [
            'skill_id' => $skill_data->id,
            'skill_name' => $skill_data->skill_name,
            'notes' => $skill_data->notes,
        ];

        return response()->json($data);
    }


    public function update_skill(Request $request)
    {
        $user_id = Auth::id();
        $userData = User::where('id', $user_id)->first();
        $user_name = $userData->user_name;

        // Find the skill by ID
        $skill_id = $request->input('skill_id');
        $skill = Skill::where('id', $skill_id)->first();
        if (!$skill) {
            return response()->json(['error' => trans('messages.skill_not_found', [], session('locale'))], 404);
        }

        $skill->skill_name = $request['skill_name'];
        $skill->notes = $request['notes'];
        $skill->updated_by = $user_name;
        $skill->user_id = $user_id;
        $skill->save();

        return response()->json(['skill_id' => $skill->id, 'skill' => 1]);
    }


    public function delete_skill(Request $request){
        $skill_id = $request->input('id');
        $skill = Skill::where('id', $skill_id)->first();
        if (!$skill) {
            return response()->json(['error' => trans('messages.skill_not_found', [], session('locale'))], 404);
        }
        $skill->delete();
        return response()->json([
            'success' => trans('messages.skill_deleted_lang', [], session('locale'))
        ]);


    }

}
