<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('dress_available')->nullable();
            $table->string('company_name'); // Company Name
            $table->string('company_email'); // Company Email
            $table->string('company_phone'); // Company Phone
            $table->string('company_cr'); // Company CR
            $table->string('company_address'); // Company Address
            $table->longText('notes')->nullable(); // Notes
            $table->string('logo')->nullable();
            $table->string('added_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->string('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
