<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('enrollments', function (Blueprint $table) {
            $table->id();
            $table->string('worker_id')->nullable(); // Customer name
            $table->string('customer_id')->nullable(); // Customer name
            $table->string('deployment_date')->nullable(); // Customer name
            $table->string('monthly_rate')->nullable(); // Address (optional)
            $table->string('years_salary')->nullable(); // Address (optional)
            $table->string('skill')->nullable(); // Address (optional)
            $table->string('duration_years')->nullable(); // Address (optional)
            $table->string('trail_days')->nullable(); // Address (optional)
            $table->string('trail_cost')->nullable(); // Address (optional)

            $table->string('months')->nullable(); // Address (optional)
            $table->string('months_salary')->nullable(); // Address (optional)
            $table->string('worker_status')->nullable()->comment('1 for trail, 2 for years, 3 for months,');
            $table->longText('notes')->nullable(); // Address (optional)
            $table->integer('user_id')->nullable(); // Foreign key to users table (nullable)
            $table->string('added_by')->nullable(); // User who added the booking
            $table->string('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('enrollments');
    }
};
