<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rene_histories', function (Blueprint $table) {
            $table->id();
            $table->string('deploy_id')->nullable();
            $table->string('worker_id')->nullable();
            $table->string('customer_id')->nullable();
            $table->string('employee_status')->nullable();
            $table->string('employee_rate')->nullable();
            $table->string('refund_amount')->nullable();
            $table->string('employee_earning')->nullable();
            $table->date('deployment_date')->nullable();
            $table->date('return_date')->nullable();
            $table->string('employee_period')->nullable();
            $table->string('trial_to_years')->nullable();
            $table->string('trail')->nullable();

            $table->string('years_salary')->nullable(); // Address (optional)
            $table->string('duration_years')->nullable(); // Address (optional)
            $table->string('trail_days')->nullable(); // Address (optional)
            $table->string('trail_cost')->nullable(); // Address (optional)
            $table->string('worker_status')->nullable()->comment('1 for trail, 2 for years, 3 for months,');
            $table->longText('notes')->nullable();
            $table->integer('user_id')->nullable(); // Foreign key to users table (nullable)
            $table->string('added_by')->nullable(); // User who added the booking
            $table->string('updated_by')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rene_histories');
    }
};
