<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('workers', function (Blueprint $table) {
            $table->id();
            $table->string('worker_name')->nullable(); // worker name
            $table->string('skill')->nullable(); // worker email (unique)
            $table->string('worker_number')->nullable(); // Phone number
            $table->text('age')->nullable(); // Address (optional)
            $table->string('nationality')->nullable(); // worker email (unique)
            $table->string('current_status')->nullable(); // Phone number
            $table->text('notes')->nullable(); // Address (optional)
            $table->integer('user_id')->nullable(); // Foreign key to users table (nullable)
            $table->string('added_by')->nullable(); // User who added the booking
            $table->string('updated_by')->nullable(); // User who updated the booking
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('workers');
    }
};
