<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = [
            ['name' => 'Afghanistan (أفغانستان)', 'code' => 'AF'],
            ['name' => 'Albania (ألبانيا)', 'code' => 'AL'],
            ['name' => 'Algeria (الجزائر)', 'code' => 'DZ'],
            ['name' => 'Andorra (أندورا)', 'code' => 'AD'],
            ['name' => 'Angola (أنغولا)', 'code' => 'AO'],
            ['name' => 'Antigua and Barbuda (أنتيغوا وباربودا)', 'code' => 'AG'],
            ['name' => 'Argentina (الأرجنتين)', 'code' => 'AR'],
            ['name' => 'Armenia (أرمينيا)', 'code' => 'AM'],
            ['name' => 'Australia (أستراليا)', 'code' => 'AU'],
            ['name' => 'Austria (النمسا)', 'code' => 'AT'],
            ['name' => 'Azerbaijan (أذربيجان)', 'code' => 'AZ'],
            ['name' => 'Bahamas (الباهاماس)', 'code' => 'BS'],
            ['name' => 'Bahrain (البحرين)', 'code' => 'BH'],
            ['name' => 'Bangladesh (بنغلاديش)', 'code' => 'BD'],
            ['name' => 'Barbados (باربادوس)', 'code' => 'BB'],
            ['name' => 'Belarus (بيلاروسيا)', 'code' => 'BY'],
            ['name' => 'Belgium (بلجيكا)', 'code' => 'BE'],
            ['name' => 'Belize (بليز)', 'code' => 'BZ'],
            ['name' => 'Benin (بنين)', 'code' => 'BJ'],
            ['name' => 'Bhutan (بوتان)', 'code' => 'BT'],
            ['name' => 'Bolivia (بوليفيا)', 'code' => 'BO'],
            ['name' => 'Bosnia and Herzegovina (البوسنة والهرسك)', 'code' => 'BA'],
            ['name' => 'Botswana (بوتسوانا)', 'code' => 'BW'],
            ['name' => 'Brazil (البرازيل)', 'code' => 'BR'],
            ['name' => 'Brunei Darussalam (بروناي دار السلام)', 'code' => 'BN'],
            ['name' => 'Bulgaria (بلغاريا)', 'code' => 'BG'],
            ['name' => 'Burkina Faso (بوركينا فاسو)', 'code' => 'BF'],
            ['name' => 'Burundi (بوروندي)', 'code' => 'BI'],
            ['name' => 'Cambodia (كمبوديا)', 'code' => 'KH'],
            ['name' => 'Cameroon (الكاميرون)', 'code' => 'CM'],
            ['name' => 'Canada (كندا)', 'code' => 'CA'],
            ['name' => 'Cape Verde (الرأس الأخضر)', 'code' => 'CV'],
            ['name' => 'Central African Republic (جمهورية إفريقيا الوسطى)', 'code' => 'CF'],
            ['name' => 'Chad (تشاد)', 'code' => 'TD'],
            ['name' => 'Chile (شيلي)', 'code' => 'CL'],
            ['name' => 'China (الصين)', 'code' => 'CN'],
            ['name' => 'Colombia (كولومبيا)', 'code' => 'CO'],
            ['name' => 'Comoros (كوموروس)', 'code' => 'KM'],
            ['name' => 'Congo (كونغو)', 'code' => 'CG'],
            ['name' => 'Democratic Republic of the Congo (جمهورية الكونغو الديمقراطية)', 'code' => 'CD'],
            ['name' => 'Costa Rica (كوستاريكا)', 'code' => 'CR'],
            ['name' => 'Croatia (كرواتيا)', 'code' => 'HR'],
            ['name' => 'Cuba (كوبا)', 'code' => 'CU'],
            ['name' => 'Cyprus (قبرص)', 'code' => 'CY'],
            ['name' => 'Czech Republic (جمهورية التشيك)', 'code' => 'CZ'],
            ['name' => 'Denmark (الدنمارك)', 'code' => 'DK'],
            ['name' => 'Djibouti (جيبوتي)', 'code' => 'DJ'],
            ['name' => 'Dominica (دومينيكا)', 'code' => 'DM'],
            ['name' => 'Dominican Republic (جمهورية الدومينيكان)', 'code' => 'DO'],
            ['name' => 'East Timor (تيمور الشرقية)', 'code' => 'TL'],
            ['name' => 'Ecuador (الإكوادور)', 'code' => 'EC'],
            ['name' => 'Egypt (مصر)', 'code' => 'EG'],
            ['name' => 'El Salvador (السلفادور)', 'code' => 'SV'],
            ['name' => 'Equatorial Guinea (غينيا الاستوائية)', 'code' => 'GQ'],
            ['name' => 'Eritrea (إريتريا)', 'code' => 'ER'],
            ['name' => 'Estonia (إستونيا)', 'code' => 'EE'],
            ['name' => 'Eswatini (إسواتيني)', 'code' => 'SZ'],
            ['name' => 'Ethiopia (إثيوبيا)', 'code' => 'ET'],
            ['name' => 'Fiji (فيجي)', 'code' => 'FJ'],
            ['name' => 'Finland (فنلندا)', 'code' => 'FI'],
            ['name' => 'France (فرنسا)', 'code' => 'FR'],
            ['name' => 'Gabon (الغابون)', 'code' => 'GA'],
            ['name' => 'Gambia (غامبيا)', 'code' => 'GM'],
            ['name' => 'Georgia (جورجيا)', 'code' => 'GE'],
            ['name' => 'Germany (ألمانيا)', 'code' => 'DE'],
            ['name' => 'Ghana (غانا)', 'code' => 'GH'],
            ['name' => 'Greece (اليونان)', 'code' => 'GR'],
            ['name' => 'Grenada (غرينادا)', 'code' => 'GD'],
            ['name' => 'Guatemala (غواتيمالا)', 'code' => 'GT'],
            ['name' => 'Guinea (غينيا)', 'code' => 'GN'],
            ['name' => 'Guinea-Bissau (غينيا بيساو)', 'code' => 'GW'],
            ['name' => 'Guyana (غيانا)', 'code' => 'GY'],
            ['name' => 'Haiti (هايتي)', 'code' => 'HT'],
            ['name' => 'Honduras (هندوراس)', 'code' => 'HN'],
            ['name' => 'Hungary (هنغاريا)', 'code' => 'HU'],
            ['name' => 'Iceland (أيسلندا)', 'code' => 'IS'],
            ['name' => 'India (الهند)', 'code' => 'IN'],
            ['name' => 'Indonesia (إندونيسيا)', 'code' => 'ID'],
            ['name' => 'Iran (إيران)', 'code' => 'IR'],
            ['name' => 'Iraq (العراق)', 'code' => 'IQ'],
            ['name' => 'Ireland (أيرلندا)', 'code' => 'IE'],
            ['name' => 'Israel (إسرائيل)', 'code' => 'IL'],
            ['name' => 'Italy (إيطاليا)', 'code' => 'IT'],
            ['name' => 'Jamaica (جامايكا)', 'code' => 'JM'],
            ['name' => 'Japan (اليابان)', 'code' => 'JP'],
            ['name' => 'Jordan (الأردن)', 'code' => 'JO'],
            ['name' => 'Kazakhstan (كازاخستان)', 'code' => 'KZ'],
            ['name' => 'Kenya (كينيا)', 'code' => 'KE'],
            ['name' => 'Kiribati (كيريباتي)', 'code' => 'KI'],
            ['name' => 'North Korea (كوريا الشمالية)', 'code' => 'KP'],
            ['name' => 'South Korea (كوريا الجنوبية)', 'code' => 'KR'],
            ['name' => 'Kuwait (الكويت)', 'code' => 'KW'],
            ['name' => 'Kyrgyzstan (قرغيزستان)', 'code' => 'KG'],
            ['name' => 'Laos (لاوس)', 'code' => 'LA'],
            ['name' => 'Latvia (لاتفيا)', 'code' => 'LV'],
            ['name' => 'Lebanon (لبنان)', 'code' => 'LB'],
            ['name' => 'Lesotho (ليسوتو)', 'code' => 'LS'],
            ['name' => 'Liberia (ليبيريا)', 'code' => 'LR'],
            ['name' => 'Libya (ليبيا)', 'code' => 'LY'],
            ['name' => 'Liechtenstein (ليختنشتاين)', 'code' => 'LI'],
            ['name' => 'Lithuania (ليتوانيا)', 'code' => 'LT'],
            ['name' => 'Luxembourg (لوكسمبورغ)', 'code' => 'LU'],
            ['name' => 'Madagascar (مدغشقر)', 'code' => 'MG'],
            ['name' => 'Malawi (مالاوي)', 'code' => 'MW'],
            ['name' => 'Malaysia (ماليزيا)', 'code' => 'MY'],
            ['name' => 'Maldives (المالديف)', 'code' => 'MV'],
            ['name' => 'Mali (مالي)', 'code' => 'ML'],
            ['name' => 'Malta (مالطا)', 'code' => 'MT'],
            ['name' => 'Marshall Islands (جزر مارشال)', 'code' => 'MH'],
            ['name' => 'Mauritania (موريتانيا)', 'code' => 'MR'],
            ['name' => 'Mauritius (موريشيوس)', 'code' => 'MU'],
            ['name' => 'Mexico (المكسيك)', 'code' => 'MX'],
            ['name' => 'Micronesia (ميكرونيزيا)', 'code' => 'FM'],
            ['name' => 'Moldova (مولدوفا)', 'code' => 'MD'],
            ['name' => 'Monaco (موناكو)', 'code' => 'MC'],
            ['name' => 'Mongolia (منغوليا)', 'code' => 'MN'],
            ['name' => 'Montenegro (مونتينيغرو)', 'code' => 'ME'],
            ['name' => 'Morocco (المغرب)', 'code' => 'MA'],
            ['name' => 'Mozambique (موزمبيق)', 'code' => 'MZ'],
            ['name' => 'Myanmar (ميانمار)', 'code' => 'MM'],
            ['name' => 'Namibia (ناميبيا)', 'code' => 'NA'],
            ['name' => 'Nauru (ناورو)', 'code' => 'NR'],
            ['name' => 'Nepal (نيبال)', 'code' => 'NP'],
            ['name' => 'Netherlands (هولندا)', 'code' => 'NL'],
            ['name' => 'New Zealand (نيوزيلندا)', 'code' => 'NZ'],
            ['name' => 'Nicaragua (نيكاراغوا)', 'code' => 'NI'],
            ['name' => 'Niger (النيجر)', 'code' => 'NE'],
            ['name' => 'Nigeria (نيجيريا)', 'code' => 'NG'],
            ['name' => 'North Macedonia (مقدونيا الشمالية)', 'code' => 'MK'],
            ['name' => 'Norway (النرويج)', 'code' => 'NO'],
            ['name' => 'Oman (عمان)', 'code' => 'OM'],
            ['name' => 'Pakistan (باكستان)', 'code' => 'PK'],
            ['name' => 'Palau (بالاو)', 'code' => 'PW'],
            ['name' => 'Panama (بنما)', 'code' => 'PA'],
            ['name' => 'Papua New Guinea (بابوا نيو غينيا)', 'code' => 'PG'],
            ['name' => 'Paraguay (باراغواي)', 'code' => 'PY'],
            ['name' => 'Peru (بيرو)', 'code' => 'PE'],
            ['name' => 'Philippines (الفلبين)', 'code' => 'PH'],
            ['name' => 'Poland (بولندا)', 'code' => 'PL'],
            ['name' => 'Portugal (البرتغال)', 'code' => 'PT'],
            ['name' => 'Qatar (قطر)', 'code' => 'QA'],
            ['name' => 'Romania (رومانيا)', 'code' => 'RO'],
            ['name' => 'Russia (روسيا)', 'code' => 'RU'],
            ['name' => 'Rwanda (رواندا)', 'code' => 'RW'],
            ['name' => 'Saint Kitts and Nevis (سانت كيتس ونيفيس)', 'code' => 'KN'],
            ['name' => 'Saint Lucia (سانت لوسيا)', 'code' => 'LC'],
            ['name' => 'Saint Vincent and the Grenadines (سانت فينسنت والغرينادين)', 'code' => 'VC'],
            ['name' => 'Samoa (ساموا)', 'code' => 'WS'],
            ['name' => 'San Marino (سان مارينو)', 'code' => 'SM'],
            ['name' => 'Sao Tome and Principe (ساو تومي وبرينسيبي)', 'code' => 'ST'],
            ['name' => 'Saudi Arabia (المملكة العربية السعودية)', 'code' => 'SA'],
            ['name' => 'Senegal (السنغال)', 'code' => 'SN'],
            ['name' => 'Serbia (صربيا)', 'code' => 'RS'],
            ['name' => 'Seychelles (سيشيل)', 'code' => 'SC'],
            ['name' => 'Sierra Leone (سيراليون)', 'code' => 'SL'],
            ['name' => 'Singapore (سنغافورة)', 'code' => 'SG'],
            ['name' => 'Slovakia (سلوفاكيا)', 'code' => 'SK'],
            ['name' => 'Slovenia (سلوفينيا)', 'code' => 'SI'],
            ['name' => 'Solomon Islands (جزر سليمان)', 'code' => 'SB'],
            ['name' => 'Somalia (الصومال)', 'code' => 'SO'],
            ['name' => 'South Africa (جنوب أفريقيا)', 'code' => 'ZA'],
            ['name' => 'South Sudan (جنوب السودان)', 'code' => 'SS'],
            ['name' => 'Spain (إسبانيا)', 'code' => 'ES'],
            ['name' => 'Sri Lanka (سريلانكا)', 'code' => 'LK'],
            ['name' => 'Sudan (السودان)', 'code' => 'SD'],
            ['name' => 'Suriname (سورينام)', 'code' => 'SR'],
            ['name' => 'Sweden (السويد)', 'code' => 'SE'],
            ['name' => 'Switzerland (سويسرا)', 'code' => 'CH'],
            ['name' => 'Syria (سوريا)', 'code' => 'SY'],
            ['name' => 'Taiwan (تايوان)', 'code' => 'TW'],
            ['name' => 'Tajikistan (طاجيكستان)', 'code' => 'TJ'],
            ['name' => 'Tanzania (تنزانيا)', 'code' => 'TZ'],
            ['name' => 'Thailand (تايلاند)', 'code' => 'TH'],
            ['name' => 'Togo (توغو)', 'code' => 'TG'],
            ['name' => 'Tonga (تونغا)', 'code' => 'TO'],
            ['name' => 'Trinidad and Tobago (ترينيداد وتوباغو)', 'code' => 'TT'],
            ['name' => 'Tunisia (تونس)', 'code' => 'TN'],
            ['name' => 'Turkey (تركيا)', 'code' => 'TR'],
            ['name' => 'Turkmenistan (تركمانستان)', 'code' => 'TM'],
            ['name' => 'Tuvalu (توفالو)', 'code' => 'TV'],
            ['name' => 'Uganda (أوغندا)', 'code' => 'UG'],
            ['name' => 'Ukraine (أوكرانيا)', 'code' => 'UA'],
            ['name' => 'United Arab Emirates (الإمارات العربية المتحدة)', 'code' => 'AE'],
            ['name' => 'United Kingdom (المملكة المتحدة)', 'code' => 'GB'],
            ['name' => 'United States (الولايات المتحدة)', 'code' => 'US'],
            ['name' => 'Uruguay (أوروغواي)', 'code' => 'UY'],
            ['name' => 'Uzbekistan (أوزبكستان)', 'code' => 'UZ'],
            ['name' => 'Vanuatu (فانواتو)', 'code' => 'VU'],
            ['name' => 'Vatican City (مدينة الفاتيكان)', 'code' => 'VA'],
            ['name' => 'Venezuela (فنزويلا)', 'code' => 'VE'],
            ['name' => 'Vietnam (فيتنام)', 'code' => 'VN'],
            ['name' => 'Yemen (اليمن)', 'code' => 'YE'],
            ['name' => 'Zambia (زامبيا)', 'code' => 'ZM'],
            ['name' => 'Zimbabwe (زيمبابوي)', 'code' => 'ZW']
        ];

        foreach ($countries as $country) {
            \App\Models\Country::create($country);
        }

    }
}
