@extends('layouts.header')

@section('main')
    @push('title')
        <title> {{ trans('messages.worker_deployment', [], session('locale')) }}</title>
    @endpush

    <style>
        .choices{
            background-color: #f8f9fa;
            border-radius: 6px;
        }
    </style>


    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18">{{ trans('messages.worker_deployment', [], session('locale')) }}
                            </h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a
                                            href="javascript: void(0);">{{ trans('messages.worker_deployment', [], session('locale')) }}</a>
                                    </li>


                                </ol>
                            </div>

                        </div>
                    </div>

                </div>
                <form action="" class="subscription_list">
                    @csrf
                    <div class="card">
                        <div class="row">
                            <div class="col-lg-3 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="choices-multiple-remove-button" class="form-label font-size-11">
                                        <i class="mdi mdi-cog font-size-11 me-1"></i> <!-- Added icon -->
                                        {{ trans('messages.select_worker_lang', [], session('locale')) }}
                                    </label>
                                    <div class="row">
                                        <div class="col-lg-11 col-md-9 col-sm-8 mb-1">
                                            <select class="form-control service_id"  id="service_id" name="service_id">
                                                <option value="">
                                                    {{ trans('messages.choose_lang', [], session('locale')) }}
                                                </option>
                                                @foreach ($workers as $work)
                                                    <option value="{{ $work->id }}">
                                                        {{ $work->worker_name ?? '' }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="customer_id" class="form-label font-size-11">
                                        <i class="mdi mdi-account font-size-11 me-1"></i>
                                        <!-- Added icon for consistency -->
                                        {{ trans('messages.select_customer_lang', [], session('locale')) }}
                                    </label>
                                    <div class="row">

                                        <div class="col-lg-10 col-md-9 col-sm-8 mb-1">
                                            <select class="form-control customer_id w-100" id="customer_id"
                                                name="customer_id">
                                                <option value="">
                                                    {{ trans('messages.choose_lang', [], session('locale')) }}
                                                </option>
                                                @foreach ($customers as $customer)
                                                    <option value="{{ $customer->id }}">
                                                        {{ $customer->customer_name ?? '' }}
                                                        ({{ $customer->customer_number ?? '' }})
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-lg-1 col-md-3 col-sm-4 mb-1">
                                            <a type="button"
                                                class="btn btn-primary w-100 d-flex justify-content-center align-items-center me-3"
                                                data-bs-toggle="modal" data-bs-target="#add_customer_modal">
                                                +
                                            </a>
                                        </div>


                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-2">
                                <div class="external-event fc-event text-dark bg-success-subtle">
                                    <label for="salary" class="form-label font-size-11">
                                        <i class="mdi mdi-calendar-check font-size-11 me-1"></i>
                                        {{ trans('messages.monthly_salary_lang', [], session('locale')) }}
                                    </label>
                                    <input type="text" class="form-control class_form isnumber salary" name="salary"
                                        id="salary">
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="external-event fc-event text-dark bg-success-subtle">
                                    <label for="skill" class="form-label font-size-11">
                                        <i class="mdi mdi-calendar-check font-size-11 me-1"></i>
                                        {{ trans('messages.skill_lang', [], session('locale')) }}
                                    </label>
                                    <input type="text" class="form-control class_form  skill" name="skill"
                                        id="skill">
                                </div>
                            </div>



                            <div class="col-lg-2">
                                <div class="external-event fc-event text-dark bg-success-subtle mt-2">
                                    <label for="deploy_date" class="form-label font-size-11">
                                        <i class="mdi mdi-cash font-size-11 me-1"></i>
                                        {{ trans('messages.deployment_date_lang', [], session('locale')) }}
                                    </label>
                                    <input type="text" class="form-control class_form deploy_date datepick"
                                        name="deploy_date" id="deploy_date">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-2 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle">
                                        <label for="salary_duration" class="form-label font-size-11">
                                            <h5 class="font-size-11 mb-3">
                                                <i class="mdi mdi-calendar font-size-11 me-1"></i>

                                                {{ trans('messages.years', [], session('locale')) }}
                                            </h5>
                                        </label>

                                        <div class="d-flex justify-content-center">
                                            <div class="form-check mx-2">
                                                <input type="checkbox" id="one_year" name="salary_duration"
                                                    value="1" class="form-check-input">
                                                <label for="one_year"
                                                    class="form-check-label">{{ trans('messages.one_year_lang', [], session('locale')) }}</label>
                                            </div>
                                            <div class="form-check mx-2">
                                                <input type="checkbox" id="two_years" name="salary_duration"
                                                    value="2" class="form-check-input">
                                                <label for="two_years"
                                                    class="form-check-label">{{ trans('messages.two_years_lang', [], session('locale')) }}</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <!-- Salary input field -->
                                <div class="col-lg-3" id="salary_field" style="display: none;">
                                    <div class="external-event fc-event text-dark bg-success-subtle">
                                        <label for="salary" class="form-label font-size-11">
                                            <i class="mdi mdi-calendar-check font-size-11 me-1"></i>
                                            {{ trans('messages.salary_lang', [], session('locale')) }}
                                        </label>
                                        <input type="text" class="form-control class_form isnumber salary_years"
                                            name="salary_years" id="salary_years">
                                    </div>
                                </div>


                                <div class="col-lg-2 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle"
                                        data-class="bg-success">
                                        <h5 class="font-size-11 mb-3">
                                            <i class="mdi mdi-plus-circle font-size-11 me-1"></i>
                                            {{ trans('messages.trail_lang', [], session('locale')) }}
                                        </h5>
                                        <div class="d-flex justify-content-center">
                                            <div class="square-switch">
                                                <input type="checkbox" id="deploy_switch" switch="success"
                                                    name="deployment" />
                                                <label for="deploy_switch"
                                                    data-on-label="{{ trans('messages.yes_lang', [], session('locale')) }}"
                                                    data-off-label="{{ trans('messages.no_lang', [], session('locale')) }}"></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-5 col-12 toggle-input" id="trail_fields" style="display: none;">
                                    <div class="row">
                                        <div class="col-lg-6 col-12">
                                            <div class="external-event fc-event text-dark bg-success-subtle">
                                                <label for="days" class="form-label font-size-11">
                                                    <i class="mdi mdi-calendar-check font-size-11 me-1"></i>
                                                    {{ trans('messages.days_lang', [], session('locale')) }}
                                                </label>
                                                <input type="number" class="form-control class_form isnumber"
                                                    name="days" id="days">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-12 mb-1">
                                            <div class="external-event fc-event text-dark bg-success-subtle mt-1">
                                                <label for="trail_cost" class="form-label font-size-11">
                                                    <i class="mdi mdi-cash font-size-11 me-1"></i>
                                                    {{ trans('messages.trail_cost_lang', [], session('locale')) }}
                                                </label>
                                                <input type="text" class="form-control class_form trail_cost"
                                                    name="trail_cost" id="trail_cost">
                                            </div>
                                        </div>
                                    </div>

                            </div>

                            <div class="col-lg-11 col-11 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle text-left notes"
                                    data-class="bg-success" style="width:106.6%;">
                                    <label for="notes" class="form-label font-size-11">
                                        <i class="mdi mdi-note-outline font-size-11 me-1"></i>
                                        <!-- Change to a note icon -->
                                        {{ trans('messages.notes_lang', [], session('locale')) }}
                                    </label>
                                    <textarea class="form-control notes" name="notes" id="notes" rows="5"></textarea>
                                </div>

                            </div>


                        </div>
                        <div class="col-lg-12 col-md-3 col-sm-4 d-flex justify-content-end subscription_btn">
                            <button type="submit" class="btn btn-primary w-100 add-url">
                                Submit
                            </button>
                        </div>

                    </div>



                    <!-- New Row for the Second Card Body -->

            </div>

            </form>


            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <div class="modal fade" id="add_customer_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">
                        {{ trans('messages.add_data_lang', [], session('locale')) }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="#" class="add_customer" method="POST">
                        @csrf
                        <input type="hidden" class="customer_id" name="customer_id">

                        <div class="row">
                            <!-- Customer Name -->
                            <div class="col-lg-4 col-12 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="customer_name" class="form-label font-size-11">
                                        <i class="mdi mdi-account font-size-11 me-1"></i>
                                        {{ trans('messages.customer_name_lang', [], session('locale')) }}
                                    </label>
                                    <input class="form-control customer_name" name="customer_name" type="text"
                                        id="customer_name">
                                </div>
                            </div>

                            <!-- Customer Number -->
                            <div class="col-lg-4 col-12 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="customer_number" class="form-label font-size-11">
                                        <i class="mdi mdi-phone font-size-11 me-1"></i>
                                        {{ trans('messages.customer_number_lang', [], session('locale')) }}
                                    </label>
                                    <input class="form-control customer_number isnumber" name="customer_number"
                                        type="text" id="customer_number">
                                </div>
                            </div>

                            <!-- Customer Email -->
                            <div class="col-lg-4 col-12 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="customer_email" class="form-label font-size-11">
                                        <i class="mdi mdi-email font-size-11 me-1"></i>
                                        {{ trans('messages.customer_email_lang', [], session('locale')) }}
                                    </label>
                                    <input class="form-control customer_email" name="customer_email" type="text"
                                        id="customer_email">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Address -->
                            <div class="col-12 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="address" class="form-label font-size-11">
                                        <i class="mdi mdi-note font-size-11 me-1"></i>
                                        {{ trans('messages.notes_lang', [], session('locale')) }}
                                    </label>
                                    <textarea class="form-control address" name="address" id="address" rows="3"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-light"
                                data-bs-dismiss="modal">{{ trans('messages.close_lang', [], session('locale')) }}</button>
                            <button type="submit"
                                class="btn btn-primary submit_form">{{ trans('messages.submit_lang', [], session('locale')) }}</button>
                        </div>
                    </form>
                </div>



            </div>
        </div>
    </div>


    @include('layouts.footer')
@endsection
