@extends('layouts.header')

@section('main')
    @push('title')
        <title> {{ trans('messages.worker_lang', [], session('locale')) }}</title>
    @endpush

    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18">{{ trans('messages.worker_lang', [], session('locale')) }}</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a
                                            href="javascript: void(0);">{{ trans('messages.pages_lang', [], session('locale')) }}</a>
                                    </li>
                                    <li class="breadcrumb-item active">
                                        {{ trans('messages.worker_lang', [], session('locale')) }}</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <button type="button" class="btn btn-primary waves-effect waves-light"
                                    data-bs-toggle="modal" data-bs-target="#add_worker_modal">
                                    {{ trans('messages.add_data_lang', [], session('locale')) }}
                                </button>
                            </div>
                            <div class="card-body">

                                <div class="table-responsive">
                                    <table id="all_worker" class="table table-bordered dt-responsive nowrap w-80">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{ trans('messages.worker_lang', [], session('locale')) }}</th>
                                                <th>{{ trans('messages.contact_lang', [], session('locale')) }}</th>
                                                <th>{{ trans('messages.natinality_lang', [], session('locale')) }}</th>
                                                <th>{{ trans('messages.current_status', [], session('locale')) }}</th>
                                                <th>{{ trans('messages.age_salary_lang', [], session('locale')) }}</th>

                                                <th>{{ trans('messages.skill_lang', [], session('locale')) }}</th>
                                                <th>{{ trans('messages.added_by_lang', [], session('locale')) }}</th>
                                                <th>{{ trans('messages.actions_lang', [], session('locale')) }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Data dynamically generated here -->
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div> <!-- end col -->
                </div> <!-- end row -->
            </div> <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

        <div class="modal fade" id="add_worker_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">
                            {{ trans('messages.add_data_lang', [], session('locale')) }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="#" class="add_worker" method="POST">
                            @csrf
                            <input type="hidden" class="worker_id" name="worker_id">

                            <div class="row">
                                <!-- worker Name -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="worker_name" class="form-label font-size-11">
                                            <i class="mdi mdi-account font-size-11 me-1"></i>
                                            {{ trans('messages.worker_name_lang', [], session('locale')) }}
                                        </label>
                                        <input class="form-control worker_name" name="worker_name" type="text" id="worker_name">
                                    </div>
                                </div>

                                <!-- worker Number -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="worker_number" class="form-label font-size-11">
                                            <i class="mdi mdi-phone font-size-11 me-1"></i>
                                            {{ trans('messages.worker_number_lang', [], session('locale')) }}
                                        </label>
                                        <input class="form-control worker_number isnumber" name="worker_number" type="text" id="worker_number">
                                    </div>
                                </div>

                                <!-- Age -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="worker_age" class="form-label font-size-11">
                                            <i class="mdi mdi-calendar font-size-11 me-1"></i>
                                            {{ trans('messages.worker_age_lang', [], session('locale')) }}
                                        </label>
                                        <input class="form-control worker_age" name="worker_age" type="number" id="worker_age">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <!-- Nationality -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="nationality" class="form-label font-size-11">
                                            <i class="mdi mdi-flag font-size-11 me-1"></i>
                                            {{ trans('messages.nationality_lang', [], session('locale')) }}
                                        </label>
                                        <select class="form-control nationality" name="nationality">
                                            <option value="">{{ trans('messages.choose_lang', [], session('locale')) }}</option>
                                            @foreach ($countries as $country)
                                                <option value="{{$country->id}}">{{$country->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <!-- Current Status -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="current_status" class="form-label font-size-11">
                                            <i class="mdi mdi-check-circle font-size-11 me-1"></i>
                                            {{ trans('messages.current_status_lang', [], session('locale')) }}
                                        </label>
                                        <select class="form-control current_status" name="current_status">
                                            <option value="">{{ trans('messages.choose_lang', [], session('locale')) }}</option>
                                            <option value="1">{{ trans('messages.trail_lang', [], session('locale')) }}</option>
                                            <option value="2">{{ trans('messages.years_lang', [], session('locale')) }}</option>
                                            <option value="4">{{ trans('messages.available_lang', [], session('locale')) }}</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Skill -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="skill" class="form-label font-size-11">
                                            <i class="mdi mdi-briefcase font-size-11 me-1"></i>
                                            {{ trans('messages.skill_lang', [], session('locale')) }}
                                        </label>
                                        <select class="form-control skill" name="skill">
                                            <option value="">{{ trans('messages.choose_lang', [], session('locale')) }}</option>
                                            @foreach ($skills as $skill)
                                                <option value="{{$skill->id}}">{{$skill->skill_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-12 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="worker_age" class="form-label font-size-11">
                                        <i class="mdi mdi-calendar font-size-11 me-1"></i>
                                        {{ trans('messages.salary_lang', [], session('locale')) }}
                                    </label>
                                    <input class="form-control salary isnumber" name="salary"  id="salary">
                                </div>
                            </div>

                            <div class="row">
                                <!-- Address -->
                                <div class="col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="notes" class="form-label font-size-11">
                                            <i class="mdi mdi-note font-size-11 me-1"></i>
                                            {{ trans('messages.notes_lang', [], session('locale')) }}
                                        </label>
                                        <textarea class="form-control notes" name="notes" id="notes" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ trans('messages.close_lang', [], session('locale')) }}</button>
                                <button type="submit" class="btn btn-primary submit_form">{{ trans('messages.submit_lang', [], session('locale')) }}</button>
                            </div>
                        </form>


                    </div>


                </div>
            </div>
        </div>

        @include('layouts.footer_content')
    </div>
    <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->
    @include('layouts.footer')
@endsection
