<?php $__env->startSection('main'); ?>
    <?php $__env->startPush('title'); ?>
        <title> <?php echo e(trans('messages.worker_lang', [], session('locale'))); ?></title>
    <?php $__env->stopPush(); ?>

    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('messages.worker_lang', [], session('locale'))); ?></h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a
                                            href="javascript: void(0);"><?php echo e(trans('messages.pages_lang', [], session('locale'))); ?></a>
                                    </li>
                                    <li class="breadcrumb-item active">
                                        <?php echo e(trans('messages.worker_lang', [], session('locale'))); ?></li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- end page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <button type="button" class="btn btn-primary waves-effect waves-light"
                                    data-bs-toggle="modal" data-bs-target="#add_worker_modal">
                                    <?php echo e(trans('messages.add_data_lang', [], session('locale'))); ?>

                                </button>
                            </div>
                            <div class="card-body">

                                <div class="table-responsive">
                                    <table id="all_worker" class="table table-bordered dt-responsive nowrap w-80">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th><?php echo e(trans('messages.worker_lang', [], session('locale'))); ?></th>
                                                <th><?php echo e(trans('messages.contact_lang', [], session('locale'))); ?></th>
                                                <th><?php echo e(trans('messages.natinality_lang', [], session('locale'))); ?></th>
                                                <th><?php echo e(trans('messages.current_status', [], session('locale'))); ?></th>
                                                <th><?php echo e(trans('messages.age_salary_lang', [], session('locale'))); ?></th>

                                                <th><?php echo e(trans('messages.skill_lang', [], session('locale'))); ?></th>
                                                <th><?php echo e(trans('messages.added_by_lang', [], session('locale'))); ?></th>
                                                <th><?php echo e(trans('messages.actions_lang', [], session('locale'))); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Data dynamically generated here -->
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div> <!-- end col -->
                </div> <!-- end row -->
            </div> <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

        <div class="modal fade" id="add_worker_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">
                            <?php echo e(trans('messages.add_data_lang', [], session('locale'))); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="#" class="add_worker" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" class="worker_id" name="worker_id">

                            <div class="row">
                                <!-- worker Name -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="worker_name" class="form-label font-size-11">
                                            <i class="mdi mdi-account font-size-11 me-1"></i>
                                            <?php echo e(trans('messages.worker_name_lang', [], session('locale'))); ?>

                                        </label>
                                        <input class="form-control worker_name" name="worker_name" type="text" id="worker_name">
                                    </div>
                                </div>

                                <!-- worker Number -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="worker_number" class="form-label font-size-11">
                                            <i class="mdi mdi-phone font-size-11 me-1"></i>
                                            <?php echo e(trans('messages.worker_number_lang', [], session('locale'))); ?>

                                        </label>
                                        <input class="form-control worker_number isnumber" name="worker_number" type="text" id="worker_number">
                                    </div>
                                </div>

                                <!-- Age -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="worker_age" class="form-label font-size-11">
                                            <i class="mdi mdi-calendar font-size-11 me-1"></i>
                                            <?php echo e(trans('messages.worker_age_lang', [], session('locale'))); ?>

                                        </label>
                                        <input class="form-control worker_age" name="worker_age" type="number" id="worker_age">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <!-- Nationality -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="nationality" class="form-label font-size-11">
                                            <i class="mdi mdi-flag font-size-11 me-1"></i>
                                            <?php echo e(trans('messages.nationality_lang', [], session('locale'))); ?>

                                        </label>
                                        <select class="form-control nationality" name="nationality">
                                            <option value=""><?php echo e(trans('messages.choose_lang', [], session('locale'))); ?></option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <!-- Current Status -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="current_status" class="form-label font-size-11">
                                            <i class="mdi mdi-check-circle font-size-11 me-1"></i>
                                            <?php echo e(trans('messages.current_status_lang', [], session('locale'))); ?>

                                        </label>
                                        <select class="form-control current_status" name="current_status">
                                            <option value=""><?php echo e(trans('messages.choose_lang', [], session('locale'))); ?></option>
                                            <option value="1"><?php echo e(trans('messages.trail_lang', [], session('locale'))); ?></option>
                                            <option value="2"><?php echo e(trans('messages.years_lang', [], session('locale'))); ?></option>
                                            <option value="4"><?php echo e(trans('messages.available_lang', [], session('locale'))); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Skill -->
                                <div class="col-lg-4 col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="skill" class="form-label font-size-11">
                                            <i class="mdi mdi-briefcase font-size-11 me-1"></i>
                                            <?php echo e(trans('messages.skill_lang', [], session('locale'))); ?>

                                        </label>
                                        <select class="form-control skill" name="skill">
                                            <option value=""><?php echo e(trans('messages.choose_lang', [], session('locale'))); ?></option>
                                            <?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($skill->id); ?>"><?php echo e($skill->skill_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-12 mb-1">
                                <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                    <label for="worker_age" class="form-label font-size-11">
                                        <i class="mdi mdi-calendar font-size-11 me-1"></i>
                                        <?php echo e(trans('messages.salary_lang', [], session('locale'))); ?>

                                    </label>
                                    <input class="form-control salary isnumber" name="salary"  id="salary">
                                </div>
                            </div>

                            <div class="row">
                                <!-- Address -->
                                <div class="col-12 mb-1">
                                    <div class="external-event fc-event text-dark bg-success-subtle p-2">
                                        <label for="notes" class="form-label font-size-11">
                                            <i class="mdi mdi-note font-size-11 me-1"></i>
                                            <?php echo e(trans('messages.notes_lang', [], session('locale'))); ?>

                                        </label>
                                        <textarea class="form-control notes" name="notes" id="notes" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(trans('messages.close_lang', [], session('locale'))); ?></button>
                                <button type="submit" class="btn btn-primary submit_form"><?php echo e(trans('messages.submit_lang', [], session('locale'))); ?></button>
                            </div>
                        </form>


                    </div>


                </div>
            </div>
        </div>

        <?php echo $__env->make('layouts.footer_content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!-- end main content-->

    </div>
    <!-- END layout-wrapper -->
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/user/Desktop/Projects/Sultan_Project/resources/views/worker_status/worker.blade.php ENDPATH**/ ?>