<script type="text/javascript">

       $(document).ready(function() {

           $('#add_service_modal').on('hidden.bs.modal', function() {
               $(".add_service")[0].reset();
               $('.service_id').val('');


           });
           $('#all_service').DataTable({
                "sAjaxSource": "<?php echo e(url('show_service')); ?>",
                "bFilter": true,
                'pagingType': 'numbers',
                "ordering": true,
            });

           $('.add_service').off().on('submit', function(e){
               e.preventDefault();
               var formdatas = new FormData($('.add_service')[0]);
               var title=$('.service_name').val();
               var cost=$('.service_cost').val();

               var id=$('.service_id').val();

               if(id!='')
               {
                   if(title=="" )
                   {
                       show_notification('error','<?php echo trans('messages.add_service_name_lang',[],session('locale')); ?>'); return false;
                   }

                   if(cost=="" )
                   {
                       show_notification('error','<?php echo trans('messages.add_service_cost_lang',[],session('locale')); ?>'); return false;
                   }
                   $('#global-loader').show();
                   before_submit();
                   var str = $(".add_service").serialize();
                   $.ajax({
                       type: "POST",
                       url: "<?php echo e(url('update_service')); ?>",
                       data: formdatas,
                       contentType: false,
                       processData: false,
                       success: function(data) {
                           $('#global-loader').hide();
                           after_submit();
                           if(data.status==1)
                           {
                               show_notification('success','<?php echo trans('messages.data_update_success_lang',[],session('locale')); ?>');
                               $('#add_service_modal').modal('hide');
                               $('#all_service').DataTable().ajax.reload();
                               return false;
                           }

                       },
                       error: function(data)
                       {
                           $('#global-loader').hide();
                           after_submit();
                           show_notification('error','<?php echo trans('messages.data_update_failed_lang',[],session('locale')); ?>');
                           $('#all_service').DataTable().ajax.reload();
                           console.log(data);
                           return false;
                       }
                   });
               }
               else if(id==''){


                   if(title=="" )
                   {
                       show_notification('error','<?php echo trans('messages.add_service_name_lang',[],session('locale')); ?>'); return false;

                   }

                   if(cost=="" )
                   {
                       show_notification('error','<?php echo trans('messages.add_service_cost_lang',[],session('locale')); ?>'); return false;
                   }
                   $('#global-loader').show();
                   before_submit();
                   var str = $(".add_service").serialize();
                   $.ajax({
                       type: "POST",
                       url: "<?php echo e(url('add_service')); ?>",
                       data: formdatas,
                       contentType: false,
                       processData: false,
                       success: function(data) {
                           $('#global-loader').hide();
                           after_submit();
                           if (data.status == 3) {
                           show_notification('error', '<?php echo trans('messages.service_number_or_contact_exist_lang', [], session('locale')); ?>');
                           return false;
                           }

                           else if(data.status==1)
                           {
                               $('#all_service').DataTable().ajax.reload();
                               show_notification('success','<?php echo trans('messages.data_add_success_lang',[],session('locale')); ?>');
                               $('#add_service_modal').modal('hide');
                               $(".add_service")[0].reset();

                               return false;
                           }
                       },
                       error: function(data)
                       {
                           $('#global-loader').hide();
                           after_submit();
                           show_notification('error','<?php echo trans('messages.data_add_failed_lang',[],session('locale')); ?>');
                           $('#all_service').DataTable().ajax.reload();
                           console.log(data);
                           return false;
                       }
                   });

               }

           });


       });




   function edit(id) {
       $('#global-loader').show();
       before_submit();
       var csrfToken = $('meta[name="csrf-token"]').attr('content');

       $.ajax({
           dataType: 'JSON',
           url: "<?php echo e(url('edit_service')); ?>",
           method: "POST",
           data: { id: id, _token: csrfToken },
           success: function(fetch) {
               $('#global-loader').hide();
               after_submit();

               if (fetch != "") {
                   // Set the service details
                   $(".service_id").val(fetch.service_id);
                   $(".service_name").val(fetch.service_name);
                   $(".service_cost").val(fetch.service_cost);
                   $(".notes").val(fetch.notes);

                   $(".modal-title").html('<?php echo trans('messages.update_lang', [], session('locale')); ?>');
               }
           },
           error: function(html) {
               $('#global-loader').hide();
               after_submit();
               show_notification('error', '<?php echo trans('messages.edit_failed_lang', [], session('locale')); ?>');
               console.log(html);
               return false;
           }
       });
   }







       function del(id) {
           Swal.fire({
               title:  '<?php echo trans('messages.sure_lang',[],session('locale')); ?>',
               text:  '<?php echo trans('messages.delete_lang',[],session('locale')); ?>',
               type: "warning",
               showCancelButton: !0,
               confirmButtonColor: "#3085d6",
               cancelButtonColor: "#d33",
               confirmButtonText: '<?php echo trans('messages.delete_it_lang',[],session('locale')); ?>',
               confirmButtonClass: "btn btn-primary",
               cancelButtonClass: "btn btn-danger ml-1",
               buttonsStyling: !1
           }).then(function (result) {
               if (result.value) {
                   $('#global-loader').show();
                   before_submit();
                   var csrfToken = $('meta[name="csrf-token"]').attr('content');
                   $.ajax({
                       url: "<?php echo e(url('delete_service')); ?>",
                       type: 'POST',
                       data: {id: id,_token: csrfToken},
                       error: function () {
                           $('#global-loader').hide();
                           after_submit();
                           show_notification('error', '<?php echo trans('messages.delete_failed_lang',[],session('locale')); ?>');
                       },
                       success: function (data) {
                           $('#global-loader').hide();
                           after_submit();
                           $('#all_service').DataTable().ajax.reload();
                           show_notification('success', '<?php echo trans('messages.delete_success_lang',[],session('locale')); ?>');
                       }
                   });
               } else if (result.dismiss === Swal.DismissReason.cancel) {
                   show_notification('success', '<?php echo trans('messages.safe_lang',[],session('locale')); ?>');
               }
           });
       }









    </script>
<?php /**PATH /home/user/Desktop/Projects/Notficaton_tatweer/resources/views/custom_js/service_js.blade.php ENDPATH**/ ?>