<?php $__env->startSection('main'); ?>
    <?php $__env->startPush('title'); ?>
        <title><?php echo e($report_name ?? ''); ?></title>
    <?php $__env->stopPush(); ?>


<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('messages.reports', [], session('locale'))); ?></h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(trans('messages.reports', [], session('locale'))); ?></a></li>
                                <li class="breadcrumb-item active"><?php echo e(trans('messages.expense_report', [], session('locale'))); ?></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">

                            <form id="incomeReportForm" action="<?php echo e(route('expense_report')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-sm-auto">
                                        <div class="d-flex align-items-center gap-4 mb-4">
                                            <div class="w-100">
                                                <label for="date_from" class="form-label"><?php echo e(trans('messages.date_from', [], session('locale'))); ?></label>
                                                <input class="form-control datepick" id="date_from" name="date_from" placeholder="<?php echo e(trans('messages.from_date', [], session('locale'))); ?>"
                                                       value="<?php echo e(old('date_from', $sdate ?? '')); ?>">
                                            </div>

                                            <div class="w-100">
                                                <label for="to_date" class="form-label"><?php echo e(trans('messages.to_date', [], session('locale'))); ?></label>
                                                <input class="form-control datepick" id="to_date" name="to_date" placeholder="<?php echo e(trans('messages.to_date', [], session('locale'))); ?>"
                                                       value="<?php echo e(old('date_to', $edate ?? '')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row text-center">
                                        <button type="button" class="col-lg-2 btn btn-danger" onclick="setDates('week')"><?php echo e(trans('messages.last_week', [], session('locale'))); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-info" onclick="setDates('month')"><?php echo e(trans('messages.last_month', [], session('locale'))); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-warning" onclick="setDates('3months')"><?php echo e(trans('messages.last_3_months', [], session('locale'))); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-primary" onclick="setDates('6months')"><?php echo e(trans('messages.last_6_months', [], session('locale'))); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-secondary" onclick="setDates('year')"><?php echo e(trans('messages.last_year', [], session('locale'))); ?></button>
                                    </div>

                                    <div class="col-sm">
                                        <div class="m-4">
                                            <button type="submit" class="btn btn-success waves-effect waves-light"><?php echo e(trans('messages.submit', [], session('locale'))); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <div class="table-responsive">
                                <table id="example" class="table align-middle dt-responsive table-check nowrap" style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                                    <thead>
                                        <tr class="bg-transparent">
                                            <th style="width: 50px; text-align:center;"><?php echo e(trans('messages.sr_no', [], session('locale'))); ?></th> <!-- New Sr. No. column -->

                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.expense_name', [], session('locale'))); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.expense_cat', [], session('locale'))); ?></th>

                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.expense_amount', [], session('locale'))); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.account', [], session('locale'))); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.expense_date', [], session('locale'))); ?></th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $sno = 0; // Initialize row counter
                                        ?>

                                        <?php if(!empty($expenses) && $expenses->isNotEmpty()): ?>
                                            <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $sno++; // Increment row counter
                                                    $payment_method= DB::table('accounts')->where('id', $exp->payment_method)->value('account_name');
                                                    $cat= DB::table('expensecats')->where('id', $exp->category_id)->value('expense_category_name');

                                                ?>
                                                <tr>
                                                    <td style="width: 120px; text-align:center;"><?php echo e($sno); ?></td>
                                                    <td style="width: 120px; text-align:center;"><?php echo e($exp->expense_name ?? trans('messages.not_available', [], session('locale'))); ?></td>
                                                    <td style="width: 120px; text-align:center;"><?php echo e($cat ?? trans('messages.not_available', [], session('locale'))); ?></td>
                                                    <td style="width: 120px; text-align:center;"><?php echo e($exp->amount ?? 0); ?></td>
                                                    <td style="width: 120px; text-align:center;"><?php echo e($payment_method ?? trans('messages.not_available', [], session('locale'))); ?></td>
                                                    <td style="width: 120px; text-align:center;"><?php echo e($exp->expense_date ?? trans('messages.not_available', [], session('locale'))); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="6" style="text-align:center;">
                                                    <?php echo e(trans('messages.no_data_available', [], session('locale'))); ?>

                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>

                                </table>

                            </div>


                        </div>


                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>

            <!-- end row -->
        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->


</div>


<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/user/Desktop/Projects/Sultan_Project/resources/views/reports/expense_report.blade.php ENDPATH**/ ?>