<?php $__env->startSection('main'); ?>
    <?php $__env->startPush('title'); ?>
        <title> <?php echo e($worker->worker_name ?? ''); ?></title>
    <?php $__env->stopPush(); ?>


    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">


                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0 font-size-18"><?php echo e($worker->worker_name ?? ''); ?> </h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a
                                            href="#"><?php echo e(trans('messages.worker_profile_lang', [], session('locale'))); ?>

                                        </a></li>
                                    <li class="breadcrumb-item active"><a href="<?php echo e(url('worker')); ?>"><?php echo e(trans('messages.workers_lang', [], session('locale'))); ?></a></li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-lg-6">
                        <div class="card" style="box-shadow: 0 4px 10px rgba(0,0,0,0.1); border-radius: 8px; overflow: hidden; background-color: #fff; max-height: 350px;">
                            <div class="card-body" style="padding: .5rem;">
                                <div class="invoice-title">
                                    <div class="d-flex align-items-center mb-3 text-center">
                                        <div class="flex-grow-1">
                                            <img src="<?php echo e(asset('images/logo-sm.svg')); ?>" alt="Logo" height="40" style="border-radius: 50%; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
                                            <h4 class="mt-2" style="font-family: 'Arial', sans-serif; font-weight: 600; color: #333; font-size: 18px;"><?php echo e($worker->worker_name ?? ''); ?></h4>
                                        </div>
                                        <input type="hidden" id="worker_id" value="<?php echo e($worker->id ?? ''); ?>">
                                    </div>

                                    <?php
                                        $skill = DB::table('skills')->where('id', $worker->skill)->value('skill_name');
                                        $nationality = DB::table('countries')->where('id', $worker->nationality)->value('name');
                                    ?>

                                    <div class="d-flex justify-content-between mb-2">
                                        <div style="flex: 1; text-align: center;">
                                            <h5 style="font-family: 'Verdana', sans-serif; color: #555; font-size: 14px;"><i class="mdi mdi-star-circle align-middle me-2" style="color: #ff6f61;"></i><?php echo e(trans('messages.skill_lang', [], session('locale'))); ?></h5>
                                            <p style="font-size: 14px; color: #777;"><?php echo e($skill ?? ''); ?></p>
                                        </div>

                                        <div style="flex: 1; text-align: center;">
                                            <h5 style="font-family: 'Verdana', sans-serif; color: #555; font-size: 14px;"><i class="mdi mdi-account-group align-middle me-2" style="color: #4caf50;"></i><?php echo e(trans('messages.nationality_lang', [], session('locale'))); ?></h5>
                                            <p style="font-size: 14px; color: #777;"><?php echo e($nationality ?? ''); ?></p>
                                        </div>

                                        <div style="flex: 1; text-align: center;">
                                            <h5 style="font-family: 'Verdana', sans-serif; color: #555; font-size: 14px;"><i class="mdi mdi-phone align-middle me-2" style="color: #2196f3;"></i><?php echo e(trans('messages.contact_lang', [], session('locale'))); ?></h5>
                                            <p style="font-size: 14px; color: #777;"><?php echo e($worker->worker_number ?? ''); ?></p>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between mb-2">
                                        <div style="flex: 1; text-align: center;">
                                            <h5 style="font-family: 'Verdana', sans-serif; color: #555; font-size: 14px;"><i class="mdi mdi-calendar align-middle me-2" style="color: #ff9800;"></i><?php echo e(trans('messages.age_lang', [], session('locale'))); ?></h5>
                                            <p style="font-size: 14px; color: #777;"><?php echo e($worker->age ?? ''); ?></p>
                                        </div>

                                        <div style="flex: 1; text-align: center;">
                                            <?php
                                                if($worker->current_status == 1){
                                                    $status = trans('messages.on_trail_lang', [], session('locale'));
                                                }
                                                else if($worker->current_status == 2){
                                                    $status = trans('messages.yearly_lang', [], session('locale'));
                                                }
                                                else if($worker->current_status == 4){
                                                    $status = trans('messages.available_lang', [], session('locale'));
                                                }
                                                else {
                                                    $status = trans('messages.unknown_lang', [], session('locale'));
                                                }
                                            ?>
                                            <h5 style="font-family: 'Verdana', sans-serif; color: #555; font-size: 14px;"><i class="mdi mdi-timer align-middle me-2" style="color: #9c27b0;"></i>Status</h5>
                                            <p style="font-size: 14px; color: #777;"><?php echo e($status ?? ''); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>




                    </div>

                    <div class="col-lg-6">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <!-- end card header -->

                                    <div class="card-body">
                                        <h5 class="text-start text-primary"><?php echo e(trans('messages.current_engangment', [], session('locale'))); ?></h5>
                                        <div class="table-responsive">
                                            <table
                                                class="table table-hover table-bordered table-striped align-middle dt-responsive nowrap"
                                                style="width: 100%; height:100%"  id="all_profile_docs_1">
                                                <thead class="table-primary">
                                                    <tr>


                                                        <th scope="col" style="text-align: start;"><?php echo e(trans('messages.customer', [], session('locale'))); ?></th>
                                                        <th scope="col" style="text-align: start;"><?php echo e(trans('messages.deploy_date', [], session('locale'))); ?></th>
                                                        <th scope="col" style="text-align: start;"><?php echo e(trans('messages.period_status', [], session('locale'))); ?></th>
                                                        <th scope="col" style="text-align: start;"><?php echo e(trans('messages.amount', [], session('locale'))); ?></th>

                                                      </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $customer= DB::table('customers')->where('id', $value->customer_id)->value('customer_name');
                                                    ?>

                                                    <tr>
                                                        <td style="text-align:center;"><?php echo e($customer ?? ''); ?></td>
                                                        <td style="text-align:center;"><?php echo e($value->deployment_date ?? ''); ?></td>
                                                        <td style="text-align:center;">
                                                            <span class="badge bg-primary"><?php echo $badgeData; ?></span>
                                                        </td>
                                                        <td style="text-align:center;">
                                                            <span class="badge bg-primary"><?php echo e($cost ?? ''); ?></span>
                                                        </td>

                                                    </tr>


                                                </tbody>
                                            </table>


                                        </div>
                                    </div>
                                    <!-- end card-body -->

                                </div><!-- end card -->
                            </div>

                        </div>
                    </div>

                </div>


                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <!-- end card header -->

                            <div class="card-body">
                                <h5 class="text-start text-primary"><?php echo e(trans('messages.employment_history_lang', [], session('locale'))); ?></h5>
                                <div class="table-responsive">
                                    <table
                                        class="table table-hover table-bordered table-striped align-middle dt-responsive nowrap"
                                        style="width: 100%;" id="all_profile_docs_1">
                                        <thead class="table-dark">
                                            <tr>
                                                <th style="text-align:center;"><?php echo e(trans('messages.customer_lang', [], session('locale'))); ?></th>
                                                <th style="text-align:center;"><?php echo e(trans('messages.deployment_date_lang', [], session('locale'))); ?></th>
                                                <th style="text-align:center;"><?php echo e(trans('messages.status_lang', [], session('locale'))); ?></th>
                                                <th style="text-align:center;"><?php echo e(trans('messages.period_lang', [], session('locale'))); ?></th>
                                                <th style="text-align:center;"><?php echo e(trans('messages.cost_lang', [], session('locale'))); ?></th>

                                            </tr>
                                        </thead>
                                        <tbody>

                                            <?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php

                                                $customer= DB::table('customers')->where('id', $hist->customer_id)->value('customer_name');
                                                if($hist->worker_status == 1){
                                                    $status = trans('messages.on_trail_lang', [], session('locale'));
                                                }
                                                else if($hist->worker_status == 2){
                                                    $status = trans('messages.yearly_lang', [], session('locale'));
                                                }
                                                else if($hist->worker_status == 4){
                                                    $status = trans('messages.available_lang', [], session('locale'));
                                                }
                                                else {
                                                    $status = trans('messages.unknown_lang', [], session('locale'));
                                                }



                                        $deploy_date = \Carbon\Carbon::parse($hist->deployment_date);
                                        $trail_days = (int) $hist->trail_days;
                                        $months = (int) $hist->months;
                                        $years = (int) $hist->duration_years;
                                        $current_date = \Carbon\Carbon::now();

                                        // Calculate the end date
                                        $end_date = $deploy_date->copy();
                                        if ($years) {
                                            $end_date->addYears($years);
                                        } elseif ($months) {
                                            $end_date->addMonths($months);
                                        } elseif ($trail_days) {
                                            $end_date->addDays($trail_days);
                                        }

                                        // Calculate remaining period


                                        // Calculate the period and cost
                                        $availability_date = $end_date->format('Y-m-d');
                                        $period = !empty($hist->duration_years) ? $hist->duration_years . ' ' . __('messages.years') :
                                            (!empty($hist->months) ? $hist->months . ' ' . __('messages.months') :
                                                (!empty($hist->trail_days) ? $hist->trail_days . ' ' . __('messages.days') :
                                                    __('messages.no_duration')));

                                        $cost = !empty($hist->trail_cost) ? $hist->trail_cost :
                                            (!empty($hist->months_salary) ? $hist->months_salary :
                                                (!empty($hist->years_salary) ? $hist->years_salary :
                                                    __('messages.no_cost')));

                                        // Prepare the badge data
                                        $badgeData = '<span class="badge bg-danger"> ' . __('messages.total_period') . ': ' . $period . '</span><br>' .
                                        '<span class="badge bg-success">' . __('messages.available_by') . ': ' . $availability_date . '</span><br>';

                                            ?>
                                            <tr>
                                                <td style="text-align:center;"><?php echo e($customer ?? ''); ?></td>
                                                <td style="text-align:center;"><?php echo e($hist->deployment_date ?? ''); ?></td>
                                                <td style="text-align:center;">
                                                    <span class="badge bg-primary"><?php echo e($status ?? ''); ?></span>
                                                </td>
                                                <td style="text-align:center;">
                                                    <span >  <?php echo $badgeData; ?></span>
                                                </td>
                                                <td style="text-align:center;">
                                                    <span class="badge bg-primary"><?php echo e($cost ?? ''); ?></span>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                        </tbody>
                                    </table>


                                </div>
                            </div>
                            <!-- end card-body -->

                        </div><!-- end card -->
                    </div>

                </div>




            </div>
            <!-- end row -->
            <!-- end row -->
        </div> <!-- container-fluid -->
    </div>



    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/user/Desktop/Projects/Sultan_Project/resources/views/worker_status/worker_profile.blade.php ENDPATH**/ ?>