<?php $__env->startSection('main'); ?>
    <?php $__env->startPush('title'); ?>
        <title>  <?php echo e($report_name ?? ''); ?></title>
    <?php $__env->stopPush(); ?>

<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('messages.reports')); ?></h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(trans('messages.reports')); ?></a></li>
                                <li class="breadcrumb-item active"><?php echo e(trans('messages.income_report')); ?></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">

                            <form id="incomeReportForm" action="<?php echo e(route('income_report')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-sm-auto">
                                        <div class="d-flex align-items-center gap-3 mb-4">
                                            <div class="w-100">
                                                <label for="date_from" class="form-label"><?php echo e(trans('messages.date_from')); ?> </label>
                                                <input class="form-control datepick" id="date_from" name="date_from" placeholder="<?php echo e(trans('messages.from_date')); ?>"
                                                       value="<?php echo e(old('date_from', $sdate ?? '')); ?>">
                                            </div>

                                            <div class="w-100">
                                                <label for="to_date" class="form-label"><?php echo e(trans('messages.date_to')); ?> </label>
                                                <input class="form-control datepick" id="to_date" name="to_date" placeholder="<?php echo e(trans('messages.to_date')); ?>"
                                                       value="<?php echo e(old('date_to', $edate ?? '')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row text-center">
                                        <button type="button" class="col-lg-2 btn btn-danger" onclick="setDates('week')"><?php echo e(trans('messages.last_week')); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-info" onclick="setDates('month')"><?php echo e(trans('messages.last_month')); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-warning" onclick="setDates('3months')"><?php echo e(trans('messages.last_3_months')); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-primary" onclick="setDates('6months')"><?php echo e(trans('messages.last_6_months')); ?></button>
                                        <button type="button" class="col-lg-2 btn btn-secondary" onclick="setDates('year')"><?php echo e(trans('messages.last_year')); ?></button>
                                    </div>

                                    <div class="col-sm">
                                        <div class="mt-4">
                                            <button type="submit" class="btn btn-success waves-effect waves-light"><?php echo e(trans('messages.submit')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <div class="table-responsive">
                                <table id="example2" class="table align-middle dt-responsive table-check nowrap" style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                                    <thead>
                                        <tr class="bg-transparent">
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_deployments')); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_income')); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_expense')); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_profit')); ?></th>
                                        </tr>

                                    </thead>
                                    <tbody>


                                        <tr>
                                            <td style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_deployments')); ?>: <?php echo e($total_deployments ?? ''); ?></td>
                                            <td style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_income')); ?>: <?php echo e($total_income ?? ''); ?></td>
                                            <td style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_expense')); ?>: <?php echo e($total_expense  ?? ''); ?></td>
                                            <td style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_profit')); ?>: <?php echo e($profit ?? ''); ?></td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>

                        </div>


                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>

            <!-- end row -->
        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/user/Desktop/Projects/Sultan_Project/resources/views/reports/income_report.blade.php ENDPATH**/ ?>